package MusicLandscape.util.matcher;

import MusicLandscape.entities.Track;
import MusicLandscape.util.MyRangeMatcher;

/**
 * Encapsulates the concept of matching a track based on its year.
 *
 * @author Jonas Altrock (ew20b126@technikum-wien.at)
 * @version 1
 * @since LabWork
 */
public class YearMatcher extends MyRangeMatcher<Track> {
    /**
     * Creates a default year matcher.<br>
     * By default, a matcher matches any year, including unknown year.
     */
    public YearMatcher() {
        this("");
    }

    /**
     * Creates a year matcher with a specified pattern.
     *
     * @param pat the pattern of this matcher
     */
    public YearMatcher(String pat) {
        super(pat);
    }

    /**
     * A track matches if its year is in the range accepted by this matcher.
     *
     * @param track the object to match
     * @return whether t matches the pattern of this matcher.
     */
    @Override
    public boolean matches(Track track) {
        return track.getYear() >= lower && track.getYear() <= upper;
    }

    /**
     * the string representation is year in range (RANGE)<br>
     * with range as described in getPattern
     *
     * @return a string representation of the object.
     */
    @Override
    public String toString() {
        return "year in range (" + lower + " " + upper + ")";
    }
}
